#
# video player example for Swftools
# J Sullivan <jsswftools@kanargh.force9.co.uk>
#

# The dimensions here are a lie - we'll be using noScale mode and resizing
# as directed by the containing HTML - but they give us an initial basis
# for laying out the various parts

.flash bbox=320x200 version=8 fps=25 filename="swfcplayer.swf" compress


# This is the main Video object for playback

.video t_video width=320 height=180


# Clicking on the starticon will start initial playback

.circle starticon_1 r=40 color=#ffffff fill=#505050 line=5
.outline starticon_2:
  M -20,-20 L 20,0 L -20,20 L -20,-20 z
.end
.filled starticon_3 outline=starticon_2 fill=#ffffff color=#ffffff

.sprite t_starticon
  .put starticon_1 x=0 y=0
  .put starticon_3 x=45 y=40
.end


# The spinner appears while we are buffering data

.circle spinner_1 r=10 color=#cfcfcf fill=#ffffff line=2
.sprite t_spinner
  .sprite spinner_2
    .put spinner_1 x=0 y=-40
  .end
  .put spinner_2 x=40 y=40

  .frame 10
    .change spinner_2 rotate=+360
.end


# The control bar at the bottom has a grey background

.box controlbar_1 width=320 height=20 color=#cfcfcf fill
.sprite t_controlbar
  .put controlbar_1 x=0 y=0
.end


# To the left are the play/pause and stop buttons

.outline play_1:
  M -3,-3 L 3,0 L -3,3 L -3,-3 z
.end
.box play_area width=20 height=20 fill=#000000
.filled play_normal outline=play_1 fill=#000000 color=#000000
.filled play_hover outline=play_1 fill=#ff0000 color=#ff0000

.button play_button
  .show play_area as=area x=0 y=0
  .show play_normal as=idle x=10 y=10
  .show play_hover as=hover x=10 y=10
  .show play_hover as=pressed x=10 y=10
  .on_press:
    _root.togglePause();
  .end
.end

.outline pause_1:
  M -3,-3 L -1,-3 L -1,3 L -3,3 L -3,-3 z
  M 1,-3 L 3,-3 L 3,3 L 1,3 L 1,-3 z
.end
.box pause_area width=20 height=20 fill=#000000
.filled pause_normal outline=pause_1 fill=#000000 color=#000000
.filled pause_hover outline=pause_1 fill=#ff0000 color=#ff0000

.button pause_button
  .show pause_area as=area x=0 y=0
  .show pause_normal as=idle x=10 y=10
  .show pause_hover as=hover x=10 y=10
  .show pause_hover as=pressed x=10 y=10
  .on_press:
    _root.togglePause();
  .end
.end

.outline stop_1:
  M -3,-3 L 3,-3 L 3,3 L -3,3 L -3,-3 z
.end
.box stop_area width=20 height=20 fill=#000000
.filled stop_normal outline=stop_1 fill=#000000 color=#000000
.filled stop_hover outline=stop_1 fill=#ff0000 color=#ff0000

.button stop_button
  .show stop_area as=area x=0 y=0
  .show stop_normal as=idle x=10 y=10
  .show stop_hover as=hover x=10 y=10
  .show stop_hover as=pressed x=10 y=10
  .on_press:
    _root.stopVideo();
  .end
.end

.sprite t_leftcontrols
  .put play_button x=0 y=0
  .put pause_button x=0 y=0
  .put stop_button x=20 y=0
.end


# In the middle is the progress bar. This has three overlayed parts:
# a light grey background, a darker grey which indicates the amount
# of video already loaded in HTTP mode, and a black bar which indicates
# the current play position.
#
# The width given here is used as the "100%" amount below - the real
# width of "progressbar" at runtime will be calculated from the actual
# player dimensions.  When we change the _width value of one of the child
# MovieClips at runtime, it is always as fraction of the original width
# of that child MovieClip as specified here.

.box progressbar_1 width=200 height=4 color=#afafaf fill
.box progressbar_2 width=200 height=4 color=#808080 fill
.box progressbar_3 width=200 height=4 color=#000000 fill

.sprite t_progressbar
  .put progressbar_1 x=0 y=8
  .sprite progressbar_loaded
    .put progressbar_2 x=0 y=0
  .end
  .sprite progressbar_played
    .put progressbar_3 x=0 y=0
  .end
  .put progressbar_loaded x=0 y=8
  .put progressbar_played x=0 y=8
.end


# To the right we have the playback position/duration as text (this is
# instantiated in the script) followed by the volume control
#
# The volume control is similar to the progress bar - it has a grey
# background which indicates the control area, overlayed by a black copy
# which indicates the current setting. Unlike the progress bar  we can't
# simply resize it, so instead we mask it with a rectangle  which is
# sized to the current volume setting. We can't apply the  mask directly
# here though, so we create the mask as a simple box  then convert it
# into a mask in the script.

.outline volume_1:
  M 0,10 L 30,10 L 30,0 L 0,10 z
.end
.filled volume_2 outline=volume_1 fill=#808080 color=#808080
.box volume_3 width=30 height=20 color=#000000 fill
.filled volume_4 outline=volume_1 fill=#000000 color=#000000

.sprite t_rightcontrols
  .sprite volume
    .put volume_2 x=0 y=5
  .end
  .sprite volume_mask
    .put volume_3 x=0 y=0
  .end
  .sprite volume_current
    .put volume_4 x=0 y=5
  .end
  .put volume x=85 y=0
  .put volume_mask x=85 y=0
  .put volume_current x=85 y=0
.end


# That's the static stuff we need done, most of the real work is in
# ActionScript...

.action:
  //
  // Our current playback state
  //

  var url = _level0.file;
  var redirect;
  var idparam = _level0.id;
  var stream = "";
  var isstreaming = false;
  var nc;
  var ns;
  var vstarted = false;
  var vpaused = false;
  var vstopping = false;
  var vdur = -1;
  var vtim = -1;

  //
  // Go to noScale mode so we can resize properly
  //

  Stage.scaleMode = "noScale";
  Stage.align = "TL";
  this.opaqueBackground = 0x1f1f1f;

  //
  // Instantiate all the static components
  //

  this.attachMovie("t_video", "video", this.getNextHighestDepth());
  video._x = 0;
  video._y = 0;
  video.smoothing = true;
  // 2==Sorenson, 3=On2 fastest, 4=On2 fast, 5=On2 hi-Q
  video.deblocking = 2;
  video._visible = false;

  this.attachMovie("t_starticon", "starticon", this.getNextHighestDepth(), { _x: 140, _y: 70 });
  this.attachMovie("t_spinner", "spinner", this.getNextHighestDepth(), { _x: 140, _y: 70 });
  spinner._visible = false;

  this.attachMovie("t_controlbar", "controlbar", this.getNextHighestDepth(), { _x: 0, _y: 180 });
  this.attachMovie("t_leftcontrols", "leftcontrols", this.getNextHighestDepth(), { _x:0, _y:180 });

  this.attachMovie("t_progressbar", "progressbar", this.getNextHighestDepth(), { _x: 50, _y: 180 });
  var progressbarfull = progressbar.progressbar_loaded._width;
  progressbar.progressbar_loaded._width = 1;
  progressbar.progressbar_played._width = 1;

  this.attachMovie("t_rightcontrols", "rightcontrols", this.getNextHighestDepth(), { _x: 200, _y: 180 });

  rightcontrols.createTextField("position", progressbar.getNextHighestDepth(), 5, 2, 70, 16);
  var tf = new TextFormat("_sans", 10, 0x000000);
  tf.align = "left";
  rightcontrols.position.setNewTextFormat(tf);

  leftcontrols.play_button._visible = false;
  leftcontrols.pause_button._visible = false;
  leftcontrols.stop_button._visible = false;

  //
  // We position elements dynamically based on the Stage size
  //

  var sorl = {};
  sorl.onResize = function()
  {
    var w = Stage.width;
    var h = Stage.height;

    video._width = w;
    video._height = h-20;

    starticon._x = (w-80) / 2;
    starticon._y = (h-100) / 2;
    spinner._x = (w-80) / 2;
    spinner._y = (h-100) / 2;

    controlbar._y = h-20;
    controlbar._width = w;

    leftcontrols._y = h-20;

    progressbar._y = h-20;
    progressbar._width = w-170;

    rightcontrols._x = w-120;
    rightcontrols._y = h-20;
  };
  Stage.addListener(sorl);
  sorl.onResize();

  //
  // The position text lists current play position and total video
  // duration
  //

  function fmt2DIG(n)
  {
    var rv = "" + n;
    if (rv.length<2) rv = "0" + rv;
    return rv;
  }

  function fmtTime(tm)
  {
    var nsecs = Math.floor(tm);
    var nmins = Math.floor(nsecs / 60);
    nsecs = nsecs % 60;
    return fmt2DIG(nmins) + ":" + fmt2DIG(nsecs);
  }

  function setPositionText()
  {
    var posstr = vtim==-1 ? "--:--" : fmtTime(vtim);
    var durstr = vdur==-1 ? "--:--" : fmtTime(vdur);
    rightcontrols.position.text = posstr + " / " + durstr;
  }

  setPositionText();

  //
  // Handle the volume control/indicator
  //

  var volumefull = rightcontrols.volume._width;
  rightcontrols.volume_current.setMask(rightcontrols.volume_mask);

  var sound = new Sound(this);

  function displayVolume()
  {
    var w = (volumefull * sound.getVolume()) / 100.0;
    rightcontrols.volume_mask.volume_3._width = w;
  }

  displayVolume();

  rightcontrols.volume.onMouseDown = function()
  {
    var mx = rightcontrols.volume._xmouse;
    var my = rightcontrols.volume._ymouse;

    if (mx>=-5 && mx<volumefull+5 && my>=5 && my<15) {
      if (mx<0) mx = 0;
      if (mx>volumefull) mx = volumefull;
      sound.setVolume((mx * 100) / volumefull);
      displayVolume();
    }
  };

  //
  // Clicking on the progress bar seeks (if possible)
  //

  progressbar.onMouseDown = function()
  {
    if (vstarted && vdur!=0.0) {
      var mx = progressbar._xmouse;
      var my = progressbar._ymouse;

      if (mx>=0 && mx<progressbarfull && my>=0 && my<20) {
        var ntim = (mx * vdur) / progressbarfull;
        ns.seek(ntim);
        vstopping = false;
      }
    }
  };

  //
  // Handle the play and pause buttons
  //

  function togglePause()
  {
    if (vstarted) {
      vpaused = !vpaused;
      ns.pause(vpaused);
      if (vpaused) {
        leftcontrols.play_button._visible = true;
        leftcontrols.pause_button._visible = false;
      } else {
        leftcontrols.play_button._visible = false;
        leftcontrols.pause_button._visible = true;
      }
    }
  }

  //
  // We accept both HTTP and RTMP sources here. RTMP sources need
  // both the server URL ("file") and a separate stream name ("id").
  // HTTP sources just need the URL ("file")
  //

  function doRedirect()
  {
    trace("redirecting to " + redirect);
    nc.connect(redirect);
  }

  function startVideo()
  {
    nc = new NetConnection();
    nc.onStatus = function(item)
    {
      trace("nc onStatus: " + item.code);
      if (item.ex) {
        trace("nc ex: " + item.ex.code + " red: " + item.ex.redirect);
      }
      if (item.code=="NetConnection.Connect.Success") {
        ns = new NetStream(nc);

        ns.onMetaData = function(item)
        {
          vdur = item.duration;
          video.width = item.width;
          video.height = item.height;
          setPositionText();
        };

        ns.onStatus = function(info)
        {
          if (info.code=="NetStream.Play.Stop") {
            if (!isstreaming) {
              stopVideo();
            } else {
              vstopping = true;
            }
          }

          if (info.code=="NetStream.Buffer.Empty") {
            if (vstopping) {
              stopVideo();
            } else {
              spinner._visible = true;
            }
          }

          if (info.code=="NetStream.Buffer.Full") {
            spinner._visible = false;
          }
        };

        ns.onPlayStatus = function(info)
        {
          if (info.code=="NetStream.Play.Complete") {
            stopVideo();
          }
        };

        video._visible = true;
        video.attachVideo(ns);
        sound.attachAudio(ns);
        trace("playing " + stream);
        ns.play(stream);
        vstarted = true;
      }

      if (item.level=="error") {
        if (item.code=="NetConnection.Connect.Rejected" && item.ex && item.ex.code==302) {
          trace("got redirect to " + item.ex.redirect);
          redirect = item.ex.redirect;
          setTimeout(doRedirect, 10);
        } else {
          stopVideo();
        }
      }
    };

    starticon._visible = false;
    spinner._visible = true;
    leftcontrols.pause_button._visible = true;
    leftcontrols.stop_button._visible = true;

    trace("url=" + url + " id=" + idparam);
    if (idparam && idparam.length>0) {
      stream = idparam;
      isstreaming = true;
      trace("nc connecting " + url + " for " + stream);
      nc.connect(url);

    } else {
      stream = url;
      isstreaming = false;
      trace("nc connecting null for " + stream);
      nc.connect(null);
    }
  }

  function stopVideo()
  {
    video._visible = false;
    video.clear();
    starticon._visible = true;
    spinner._visible = false;
    leftcontrols.play_button._visible = false;
    leftcontrols.pause_button._visible = false;
    leftcontrols.stop_button._visible = false;
    progressbar.progressbar_loaded._width = 1;
    progressbar.progressbar_played._width = 1;
    vtim = -1;
    vdur = -1;
    setPositionText();
    vstopping = false;
    if (ns) {
      ns.close();
      ns = null;
    }
    if (nc) {
      nc.close();
      nc = null;
    }
    vstarted = false;
  }

  //
  // Clicking the start icon initiates playback
  //

  starticon.onPress = function()
  {
    startVideo();
  };

  //
  // Every 100ms we update the progress bar and position indicators
  //

  function tick()
  {
    if (vstarted) {
      vtim = ns.time;

      if (!isstreaming) {
        if (ns.bytesTotal>0) {
          var nw = (progressbarfull * ns.bytesLoaded) / ns.bytesTotal;
          if (nw<1) nw = 1;
          if (nw>progressbarfull) nw = progressbarfull;
          progressbar.progressbar_loaded._width = nw;
        } else {
          progressbar.progressbar_loaded._width = 1;
        }
      } else {
        progressbar.progressbar_loaded._width = progressbarfull;
      }

      if (vdur==-1) {
        progressbar.progressbar_played._width = 1;
      } else {
        var nw = (progressbarfull * vtim) / vdur;
        if (nw<1) nw = 1;
        if (nw>progressbarfull) nw = progressbarfull;
        progressbar.progressbar_played._width = nw;
        setPositionText();
      }
    }
  };

  setInterval(this, "tick", 100);

.end

.end
