//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#ifndef _FIELDMETER_H_
#define _FIELDMETER_H_

#include "meter.h"

class FieldMeter : public Meter {
public:
  FieldMeter( XOSView *parent, int x, int y,
	      int width, int height, int numfields,
	      const char *title = "", const char *legend = "", 
	      int dolegends = 0, int dousedlegends = 0 );
  ~FieldMeter( void );
  
  void drawfields( int manditory = 0 );
  void setfieldcolor( int field, const char *color );
  void dolegends( int val ) { dolegends_ = val; }
  void dousedlegends( int val ) { dousedlegends_ = val; }
  void reset( void );
  void used( int val ) { used_ = val; }
  void draw( void );
  void checkevent( void );
  
  void checkResources( void );

protected:
  int numfields_;
  float *fields_, total_;
  int *lastvals_, *lastx_, used_, lastused_;
  unsigned long *colors_, usedcolor_;

  void drawlegend( void );
  void drawused( int manditory );
private:
};

#endif
