/* -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef MATH_MAIN_H_
#define MATH_MAIN_H_
/* Header file for Main window and About classes */

#include <qwidget.h>
#include <qlabel.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qfile.h>
#include <qtstream.h>
#include <qlist.h>
#include <qprinter.h>
#include "../equations/parser.h"
#include "../equations/errors.h"
#include "../dialogs/graphtab.h"
#include "graphwin.h"

class EquationFrame;
class IconBar;

struct setup
{
  bool Radians;
  bool SciNot;
  int SigFig;
  range Range;
  graphsize GraphType;
  bool Auto;
};

class Math_Main : public QFrame
{
  Q_OBJECT
 public:
  Math_Main( QWidget *, char *, char *, const char * = NULL);
  ~Math_Main();
  void SelectEqu(int);
  bool ErrorCheck(error_type);
  bool ErrorCheck(error_struct);
  void Update();
  void NumberToOutput(double);
  void DrawGraph(int);
  void SaveFile(QString *);
  int OpenFile(QString *);

 private:
  void grey();
  void ungrey();
  void setMenu();
  void InitVariables();
  void LoadDefaults(char *);

 public slots:
  void new_();      // File menu
  void open_();
  void save();
  void save_as();
  void log_to_file();
  void quit_app();
  void cut();      // Edit menu
  void paste();
  void copy();
  void clear();
  void undo();
  void enter();    // Equation menu  
  void edit_();
  void select();
  void delete_();
  void delete_current();
  void delete_all();
  void tidy();
  void set_variables();
  void evaluate(); // Evaluating menu
  void integrate();
  void find_root();
  void differentiate();
  void power_series();
  void ode();
  void plot_graph(); // Graph menu
  void graph_pref();
  void delete_graphs();
  void sig_fig();  // Options menu
  void sci_not();
  void angle();
  void contents(); // Help menu
  void about();
  void mouse( QPoint , int, int ); // Misc events
  void icon_pressed( int );
  void CopyOutput();
  void delete_graph( bool, GraphWin * );

 protected:
  void resizeEvent( QResizeEvent * );
    
 public:
  EquationFrame *EqnFrame;
  QList<Equation> Equations;  // List of equations
  int CurrentEqu,Equ2;
  bool SciNot,Radians,Auto;
  int SigFig;
  range Range;
  graphsize GraphType;
  variable *Variable;
  variable *Variable1;
  variable *Variable2;
  QString *Filename;
  QTextStream *LogStream;

 private:
  QMenuBar *menu;  /* Menus */
  QPopupMenu *fileMenu;
  QPopupMenu *editMenu;
  QPopupMenu *equationMenu;
  QPopupMenu *evaluatingMenu;
  QPopupMenu *graphMenu;
  QPopupMenu *optionsMenu;
  QPopupMenu *helpMenu;
  QPopupMenu *eqnPopup;
  QPopupMenu *outputPopup;

  QList<GraphWin> Graph;  // Graph window
  Parser parser;  // Equation parser
  IconBar *Icons;   // Icon bar for main window
  QPrinter *printer; // Printer
  QClipboard *clip;  // Clipboard
  QFile *LogFile;  // Log file

  QLabel *output,*outlabel;  /* For output window */

  //  int flag;

  char ans[20];
  Equation *oldEqn;

  /* Menu ID's */
  int NewID, OpenID, SaveID, SaveAsID, LogToFileID, ExitID;
  int CutID, PasteID, CopyID, CopyOutputID, ClearID, UndoID;
  int EnterID, EditID, SelectID, DeleteID, DeleteAllID, TidyUpID, SetVarID;
  int EvaluateID, IntegrateID, FindRootID, DifferentiateID, PowerSeriesID, OdeID;
  int GraphID, GraphPrefID, DeleteGraphsID;
  int SigFigID, SciNotID, AngleID;
  int ContentsID, AboutID;

  int PopupEnterID, PopupEditID, PopupDeleteID, PopupTidyUpID;

  setup Defaults;  /* Default values for variables */
};

#endif /* MATH_MAIN_H_ */

