/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

//Class for IconBar window

#include "iconbar.h"
#include "icons.h"
#include <qtooltip.h>
#include <qpixmap.h>

// Constructor for IconBar window
IconBar::IconBar( QWidget *parent, const char *name ) : QButtonGroup( parent, name )
{
  int i;

  buttons.clear();
  setFrameStyle( QFrame::Box | QFrame::Plain );

  // Enter equation
  buttons.append(new QPushButton( this ));
  QPixmap enter_pixmap( enter_xpm );
  buttons.current()->setPixmap( enter_pixmap );
  insert(buttons.current(), ENTER_BUTTON);
  QToolTip::add(buttons.current(),"Enter equation");

  // Edit equation
  buttons.append(new QPushButton( this ));
  QPixmap edit_pixmap( edit_xpm );
  buttons.current()->setPixmap( edit_pixmap );
  insert(buttons.current(), EDIT_BUTTON);
  QToolTip::add(buttons.current(),"Edit equation");

  // Delete equation
  buttons.append(new QPushButton( this ));
  QPixmap del_pixmap( del_xpm );
  buttons.current()->setPixmap( del_pixmap );
  insert(buttons.current(), DELETE_BUTTON);
  QToolTip::add(buttons.current(),"Delete equation");

  // Tidy equation
  buttons.append(new QPushButton( this ));
  QPixmap tidy_pixmap( tidy_xpm );
  buttons.current()->setPixmap( tidy_pixmap );
  insert(buttons.current(), TIDY_BUTTON);
  QToolTip::add(buttons.current(),"Tidy up\nequation");

  // Evaluate equation
  buttons.append(new QPushButton( this ));
  QPixmap eval_pixmap( eval_xpm );
  buttons.current()->setPixmap( eval_pixmap );
  insert(buttons.current(), EVALUATE_BUTTON);
  QToolTip::add(buttons.current(),"Evaluate\nequation");

  // Integrate equation
  buttons.append(new QPushButton( this ));
  QPixmap int_pixmap( int_xpm );
  buttons.current()->setPixmap( int_pixmap );
  insert(buttons.current(), INTEGRATE_BUTTON);
  QToolTip::add(buttons.current(),"Integrate\nequation");

  // Root equation
  buttons.append(new QPushButton( this ));
  QPixmap root_pixmap( root_xpm );
  buttons.current()->setPixmap( root_pixmap );
  insert(buttons.current(), ROOT_BUTTON);
  QToolTip::add(buttons.current(),"Find root of\nequation");

  // Diff equation
  buttons.append(new QPushButton( this ));
  QPixmap diff_pixmap( diff_xpm );
  buttons.current()->setPixmap( diff_pixmap );
  insert(buttons.current(), DIFF_BUTTON);
  QToolTip::add(buttons.current(),"Differentiate\nequation");

  // Power equation
  buttons.append(new QPushButton( this ));
  QPixmap power_pixmap( power_xpm );
  buttons.current()->setPixmap( power_pixmap );
  insert(buttons.current(), POWER_BUTTON);
  QToolTip::add(buttons.current(),"Calculate power\nseries of equation");

  // Ode equation
  buttons.append(new QPushButton( this ));
  QPixmap ode_pixmap( ode_xpm );
  buttons.current()->setPixmap( ode_pixmap );
  insert(buttons.current(), ODE_BUTTON);
  QToolTip::add(buttons.current(),"Ordinary differential\nequation");

  // Graph equation
  buttons.append(new QPushButton( this ));
  QPixmap graph_pixmap( graph_xpm );
  buttons.current()->setPixmap( graph_pixmap );
  insert(buttons.current(), GRAPH_BUTTON);
  QToolTip::add(buttons.current(),"Graph equation");

  buttons.first();
  i = 0;
  while ( buttons.current() != NULL ) {
    buttons.current()->setGeometry(5+36*i,5,34,34);
    i++;
    buttons.next();
  }

  resize(36*i+8,44);
}

// Destructor for IconBar window
IconBar::~IconBar()
{
  buttons.clear();
}

#include "iconbar.moc"


