/*  -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef GRAPHWIN_H_
#define GRAPHWIN_H_
/* Header file for Graph window class */

#include <qwidget.h>
#include <qpntarry.h>
#include <qprinter.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qprinter.h>
#include "../dialogs/grbase.h"

class Math_Main;

#define NUMPLOTS 5

class GraphWin : public QWidget
{
  Q_OBJECT
 public:
  GraphWin( Math_Main *, double *, int, graphsize, bool, QPrinter *, const char * = NULL );
  ~GraphWin();
  void addPlot( double *, int, graphsize, bool );
  void addFirstPlot( double *, int, graphsize, bool, bool );

 protected:
  void setRange();
  void setSpacing(double, double, double &, double &, int &);
  void paintEvent( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  void closeEvent( QCloseEvent * );
  void drawGraph( QPainter *, bool );

 signals:
  void deleteGraph( bool, GraphWin *);

 public slots:
  void delete_pressed();
  void printPlot();

 protected:
  Math_Main *Parent;
  double *Array[NUMPLOTS];
  QPointArray Points[NUMPLOTS];
  QPointArray Tics,Grid;
  QPoint Xaxis_min,Xaxis_max,Yaxis_min,Yaxis_max;
  QPoint Xlabel_min,Xlabel_max,Ylabel_min,Ylabel_max;
  QPoint Xmin_shift,Xmax_shift,Ymin_shift,Ymax_shift;
  QRect TextRect[NUMPLOTS],GraphRect;
  int ArraySize[NUMPLOTS];
  graphsize GraphType[NUMPLOTS];
  int Equ1,Equ2,numplots,fontheight;
  int xval,yval;
  QString Title[NUMPLOTS];
  QString Xmin_text;
  QString Xmax_text;
  QString Ymin_text;
  QString Ymax_text;
  bool AutoRange,IsSingular;
  double xmin,xmax,ymin,ymax;
  double xtic_min, ytic_min, xtic_spacing, ytic_spacing;
  int num_xtics, num_ytics;
  double xgrid_min, ygrid_min, xgrid_spacing, ygrid_spacing;
  int num_xgrids, num_ygrids;

  int DeleteID, PrintID; /* Menu id's */
  QMenuBar *menu;
  QPopupMenu *graphMenu;

  QPrinter *printer;
};


#endif /* GRAPHWIN_H_ */
