/*   -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef EQNFRAME_H_
#define EQNFRAME_H_

/* Header file for EquationFrame class for frame to handle mouse presses and
scroll bars. */

#include <qstring.h>
#include <qlist.h>
#include <qtablevw.h>
#include <qpainter.h>
#include "../equations/equ.h"

class EquationFrame : public QTableView
{
  Q_OBJECT
 public:
  EquationFrame( QWidget *, QList<Equation> * );
  ~EquationFrame();
  void changeLabels();
  void selectLabel(int);
  
 protected:
  void paintCell( QPainter *, int, int );
  int cellWidth(int);
  int totalWidth();
  void mousePressEvent( QMouseEvent * );

 signals:
  void buttonpressed( QPoint ,int , int );

 private:
  QList<Equation> *EqnList;
  int selected, eqnWidth;
};

#endif /* EQNFRAME_H_ */




