/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// Class for EquationFrame.

#include "eqnframe.h"

// Class for widget displaying equations
EquationFrame::EquationFrame(QWidget *parent, QList<Equation> *list) : QTableView( parent, "" )
{
  EqnList = list;
  selected = 0;
  setNumCols( 2 );
  setNumRows( 0 );
  setCellHeight( 30 );                        // set height of cell in pixels
  eqnWidth = 0;
  setTableFlags( Tbl_autoScrollBars | Tbl_clipCellPainting | Tbl_smoothScrolling);
  setFrameStyle( QFrame::Panel | QFrame::Raised );
}


EquationFrame::~EquationFrame()
{
}

// Change the number of labels
void
EquationFrame::changeLabels()
{
  char *text;
  QRect rect;

  eqnWidth = 0;
  if (EqnList->first() != NULL) {
    do {
      text = EqnList->current()->EquationText;
      rect = fontMetrics().boundingRect(text);
      if ( rect.width() + 10 > eqnWidth ) eqnWidth = rect.width() + 10;
    } while ( EqnList->next() != NULL );
  }
  setNumRows( EqnList->count() );
  resize( size() );
}

// Select a label
void
EquationFrame::selectLabel(int seleqn)
{
  if ( (numRows() >= seleqn) && (seleqn > 0) ) {
    selected = seleqn;
    if (!rowIsVisible(seleqn-1))
      setTopCell(seleqn-1);
  }
  else 
    selected = 0;
}

// Mouse button pressed in frame
void 
EquationFrame::mousePressEvent( QMouseEvent *event)
{
  emit buttonpressed( mapToGlobal(event->pos()) , event->button(), findRow( event->y() )+1  );
}

// Return width in pixels of cell in column col
int
EquationFrame::cellWidth(int col)
{
  int w;

  switch (col) {
  case 0:
    return 30;
  case 1:
    w = viewWidth()-30;
    return ( (eqnWidth > w) ? eqnWidth : w );
  }
  return 0;
}

// Return total table width in pixels
int
EquationFrame::totalWidth()
{
  int w = viewWidth();
  return ( (eqnWidth + 30 > w) ? (eqnWidth + 30) : w );
}

// Paint a cell
void
EquationFrame::paintCell( QPainter *p, int row, int col )
{
  QString numLabel(10);

  int w = cellWidth( col );
  int h = cellHeight( row );
  int x2 = w - 1;
  int y2 = h - 1;
  
  if ( ( row + 1 == selected ) && ( col == 1 ) ) {
    p->setPen( palette().normal().light() );
    p->drawLine( x2, 0, x2, y2 );
    p->drawLine( 0, y2, x2, y2 );
    p->setPen( palette().normal().dark() );
    p->drawLine( 0, 0, 0, y2 );
    p->drawLine( 0, 0, x2, 0 );
  }
  else {
    p->setPen( palette().normal().dark() );
    p->drawLine( x2, 0, x2, y2 );
    p->drawLine( 0, y2, x2, y2 );
    p->setPen( palette().normal().light() );
    p->drawLine( 0, 0, 0, y2 );
    p->drawLine( 0, 0, x2, 0 );
  }

  p->setPen( palette().normal().foreground() );
  switch(col) {
  case 0:
    numLabel.setNum( row+1 );
    p->drawText( 0, 0, w, h, AlignCenter, numLabel );
    break;
  case 1:
    p->drawText( 5, 5, w-10, h-10, AlignLeft | AlignVCenter, EqnList->at(row)->EquationText );
    break;
  }
}

#include "eqnframe.moc"



