/*   -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef POWERVAR_H_
#define POWERVAR_H_
/* Header file for PowerVar class */

#include "eqndialog.h"
#include <qlined.h>
#include <qlistbox.h>
#include "../equations/equ.h"

class PowerVar : public EqnDialog
{
  Q_OBJECT
 public:
  PowerVar( Equation *, int *v, uint *t, Parser *, const char * =0 );
  ~PowerVar();

 public slots:
  void button_ok();
  void listbox_selected( int );

 protected:
  QListBox *listbox;
  QLineEdit *value_edit;
  QLineEdit *terms_edit;
  Equation *equation;
  variable *var;
  double value;
  int *varnum;
  uint *terms;
};

#endif /* SETVAR_H_ */
