/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for NumInt class

#include "numint.h"
#include "setvar.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qmsgbox.h>
#include <qregexp.h>

NumInt::NumInt( int * v, Equation *e, range *r, char *titletext, char *text1, char *text2, Parser *p, char *name ) : EqnDialog ( p, 0, name, TRUE )
{
  variable *var;
  QString text;

  Range = r;
  var_num = v;
  equ = e;
  resize( 360 , 280 );

  QLabel *label = new QLabel( titletext, this );
  label->setGeometry(30,10,300,15);
  label->setAlignment( AlignCenter );

  label = new QLabel("Variable",this);   // Set up listbox of variables
  label->setGeometry(30,30,100,15);
  label->setAlignment( AlignCenter );

  listbox = new QListBox( this );   
  var = equ->Variables.first();
  while ( var ) {
    listbox->insertItem(var->Name);
    var = equ->Variables.next();
  }
  var = equ->Variables.first();
  listbox->setGeometry( 30, 50, 100, 130 );
  listbox->setCurrentItem( 0 );

  label = new QLabel(text1,this); 
  label->setGeometry( 180, 30, 150, 20 );

  edit_from = new QLineEdit(this);   // Set up line edit for from
  edit_from->setGeometry( 180, 70, 150, 30 );
  text.setNum( Range->From , 'G' );
  edit_from->setText( text );
  label = new QLabel("From",this);
  label->setGeometry( 180, 50, 150, 20 );
  connect(edit_from, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_to = new QLineEdit(this);   // Set up line edit for to
  edit_to->setGeometry( 180, 130, 150, 30 );
  text.setNum( Range->To , 'G' );
  edit_to->setText( text );
  label = new QLabel("To",this);
  label->setGeometry( 180, 110, 150, 20 );
  connect(edit_to, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_step = new QLineEdit(this);   // Set up line edit for step
  edit_step->setGeometry( 180, 190, 150, 30 );
  text.setNum( Range->Step , 'G' );
  edit_step->setText( text );
  label = new QLabel(text2,this);
  label->setGeometry( 180, 170, 150, 20 );
  connect(edit_step, SIGNAL(returnPressed()), SLOT(button_ok()) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button
  button->setGeometry( 40, 240, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->setGeometry( 250, 240, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  button = new QPushButton("Set\nVariables",this);  // Set up Set Variables button
  button->setGeometry( 145, 240, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(set_var()) );

  listbox->setFocus();
}

NumInt::~NumInt()
{
  delete listbox;
  delete edit_from;
  delete edit_to;
  delete edit_step; 
}

// Set Variables button pressed
void 
NumInt::set_var()
{
  SetVar SetVarVal( equ, NULL, parser );
  SetVarVal.exec();
}

// OK button pressed
void 
NumInt::button_ok()
{
  range r;

  r.From = EvalText( edit_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };

    r.To = EvalText( edit_to->text() );
    if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

    r.Step = EvalText( edit_step->text() );
    if ( Error || r.Step<=0 ) {
    QMessageBox::message("Error!","Not a valid step size value");
    return;
  };

  if ( r.From >= r.To ) {
    QMessageBox::message("Error!","from value must be less than to value");
    return;
  };

  *var_num = listbox->currentItem() + 1;
  Range->From = r.From;
  Range->To = r.To;
  Range->Step = r.Step;

  accept();
  
}

#include "numint.moc"
