/*  -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef GRAPHBASE_H_
#define GRAPHBASE_H_
/* Header file for GraphBaseDlg dialog class */

#include <qtabdlg.h>
#include <qlined.h>
#include <qbttngrp.h>
#include <qlabel.h>
#include <qtstream.h>
#include "../equations/parser.h"

struct graphsize {
  double varmin;      // Variable range
  double varmax;
  double xmin;        // x axis range
  double xmax;
  double ymin;        // y axis range
  double ymax;
  bool Cartesian;     // Cartesian graph
  bool Parametric;    // Paramteric graph
  bool Replot;        // Add to existing plot / new plot
  bool Auto;          // Automatically set range
  double x_tic_space;   // Set spacing of x tic marks
  double y_tic_space;   // Set spacing of y tic marks
  double x_grid_space;  // Set spacing of x grid
  double y_grid_space;  // Set spacing of y grid
};

class GraphBaseDlg : public QTabDialog
{
  Q_OBJECT
 public:
  GraphBaseDlg( graphsize *, Parser *, char * =0 );
  ~GraphBaseDlg();

 public slots:
  virtual void apply();
  void auto_pressed(int);
  void xtic_pressed(int);
  void ytic_pressed(int);
  void xgrid_pressed(int);
  void ygrid_pressed(int);

 protected:
  double EvalText(const char *);

 protected:
  Parser *parser;
  QWidget *range_page, *draw_page;

  // Widgets for range tab
  QLineEdit *edit_from;
  QLineEdit *edit_to;
  QLineEdit *x_from;
  QLineEdit *x_to;
  QLineEdit *y_from;
  QLineEdit *y_to;
  QButtonGroup *AutoRange;

  // Widgets for draw options tab
  QButtonGroup *x_tic;
  QLineEdit *edit_x_tic;
  QButtonGroup *y_tic;
  QLineEdit *edit_y_tic;
  QButtonGroup *x_grid;
  QLineEdit *edit_x_grid;
  QButtonGroup *y_grid;
  QLineEdit *edit_y_grid;

  graphsize *graph, int_graph;
  bool Error;
};

#endif /* GRAPHBASE_H_ */







