/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for GraphBaseDlg dialog class

#include "grbase.h"
#include <qpushbt.h>
#include <qradiobt.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qregexp.h>
#include "../equations/errors.h"

GraphBaseDlg::GraphBaseDlg( graphsize *g, Parser *p, char *name ) : QTabDialog(NULL, name, TRUE)
{
  QString text;
  QLabel *label;

  parser = p;
  graph = g;

  int_graph = *graph;

  resize( 400 , 500 );

  // Create widgets for the pages
  range_page = new QWidget(this, "range_tab");
  range_page->resize(300,350);
  draw_page = new QWidget(this, "draw_tab");
  draw_page->resize(300,350);

  setCaption("Set graph preferences");

  // Widgets for the range tab
  AutoRange = new QButtonGroup(range_page);  // Set up auto radio button
  AutoRange->setTitle("Set range");
  QRadioButton *radiobutton = new QRadioButton("Auto", AutoRange);
  radiobutton->setGeometry(10,15,140,25);
  if (int_graph.Auto) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Manual", AutoRange);
  radiobutton->setGeometry(10,45,140,25);
  if (!int_graph.Auto) radiobutton->setChecked(TRUE);
  AutoRange->setGeometry(40,10,160,80);
  connect(AutoRange, SIGNAL(pressed(int)), SLOT(auto_pressed(int)) );

  edit_from = new QLineEdit(range_page);   // Set up line edit for from
  edit_from->setGeometry( 30, 130, 150, 30 );
  text.setNum( graph->varmin , 'G' );
  edit_from->setText( text );
  label = new QLabel("Variable from value",range_page);
  label->setGeometry( 30, 110, 150, 20 );

  edit_to = new QLineEdit(range_page);   // Set up line edit for to
  edit_to->setGeometry( 220, 130, 150, 30 );
  text.setNum( graph->varmax , 'G' );
  edit_to->setText( text );
  label = new QLabel("Variable to value",range_page);
  label->setGeometry( 220, 110, 150, 20 );

  x_from = new QLineEdit(range_page);   // Set up line edit for from
  x_from->setGeometry( 30, 200, 150, 30 );
  text.setNum( graph->xmin , 'G' );
  x_from->setText( text );
  label = new QLabel("Horizontal from value",range_page);
  label->setGeometry( 30, 180, 150, 20 );

  x_to = new QLineEdit(range_page);   // Set up line edit for to
  x_to->setGeometry( 220, 200, 150, 30 );
  text.setNum( graph->xmax , 'G' );
  x_to->setText( text );
  label = new QLabel("Horizontal to value",range_page);
  label->setGeometry( 220, 180, 150, 20 );

  y_from = new QLineEdit(range_page);   // Set up line edit for from
  y_from->setGeometry( 30, 270, 150, 30 );
  text.setNum( graph->ymin , 'G' );
  y_from->setText( text );
  label = new QLabel("Vertical from value",range_page);
  label->setGeometry( 30, 250, 150, 20 );

  y_to = new QLineEdit(range_page);   // Set up line edit for to
  y_to->setGeometry( 220, 270, 150, 30 );
  text.setNum( graph->ymax , 'G' );
  y_to->setText( text );
  label = new QLabel("Vertical to value",range_page);
  label->setGeometry( 220, 250, 150, 20 );

  if (int_graph.Auto)
    auto_pressed(0);
  else
    auto_pressed(1);


  // Widgets for the draw tab
  x_tic = new QButtonGroup(draw_page);  // Set up x tic radio button
  x_tic->setTitle("Horizontal tics");
  radiobutton = new QRadioButton("Auto spacing", x_tic);
  radiobutton->setGeometry(10,15,140,25);
  if (!int_graph.x_tic_space) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Manual spacing", x_tic);
  radiobutton->setGeometry(10,45,140,25);
  if (int_graph.x_tic_space) radiobutton->setChecked(TRUE);
  x_tic->setGeometry(30,10,160,80);
  connect(x_tic, SIGNAL(pressed(int)), SLOT(xtic_pressed(int)) );
  
  edit_x_tic = new QLineEdit(draw_page);   // Set up line edit for x tics
  edit_x_tic->setGeometry( 220, 40, 150, 30 );
  if (int_graph.x_tic_space) {
    text.setNum( int_graph.x_tic_space , 'G' );
    edit_x_tic->setText( text );
  }
  else {
    edit_x_tic->setEnabled(false);
  }
  label = new QLabel("Horizontal tic spacing",draw_page);
  label->setGeometry( 220, 20, 150, 20 );

  y_tic = new QButtonGroup(draw_page);  // Set up y tic radio button
  y_tic->setTitle("Vertical tics");
  radiobutton = new QRadioButton("Auto spacing", y_tic);
  radiobutton->setGeometry(10,15,140,25);
  if (!int_graph.y_tic_space) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Manual spacing", y_tic);
  radiobutton->setGeometry(10,45,140,25);
  if (int_graph.y_tic_space) radiobutton->setChecked(TRUE);
  y_tic->setGeometry(30,100,160,80);
  connect(y_tic, SIGNAL(pressed(int)), SLOT(ytic_pressed(int)) );
  
  edit_y_tic = new QLineEdit(draw_page);   // Set up line edit for y tics
  edit_y_tic->setGeometry( 220, 130, 150, 30 );
  if (int_graph.y_tic_space) {
    text.setNum( int_graph.y_tic_space , 'G' );
    edit_y_tic->setText( text );
  }
  else {
    edit_y_tic->setEnabled(false);
  }
  label = new QLabel("Vertical tic spacing",draw_page);
  label->setGeometry( 220, 110, 150, 20 );

  x_grid = new QButtonGroup(draw_page);  // Set up x grid radio button
  x_grid->setTitle("Horizontal grid");
  radiobutton = new QRadioButton("Grid off", x_grid);
  radiobutton->setGeometry(10,15,140,25);
  if (int_graph.x_grid_space < 0) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Auto spacing", x_grid);
  radiobutton->setGeometry(10,40,140,25);
  if (int_graph.x_grid_space == 0) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Manual spacing", x_grid);
  radiobutton->setGeometry(10,65,140,25);
  if (int_graph.x_grid_space > 0) radiobutton->setChecked(TRUE);
  x_grid->setGeometry(30,200,160,95);
  connect(x_grid, SIGNAL(pressed(int)), SLOT(xgrid_pressed(int)) );
  
  edit_x_grid = new QLineEdit(draw_page);   // Set up line edit for x grid
  edit_x_grid->setGeometry( 220, 245, 150, 30 );
  if (int_graph.x_grid_space > 0) {
    text.setNum( int_graph.x_grid_space , 'G' );
    edit_x_grid->setText( text );
  }
  else {
    edit_x_grid->setEnabled(false);
  }
  label = new QLabel("Horizontal grid spacing",draw_page);
  label->setGeometry( 220, 225, 150, 20 );

  y_grid = new QButtonGroup(draw_page);  // Set up y grid radio button
  y_grid->setTitle("Vertical grid");
  radiobutton = new QRadioButton("Grid off", y_grid);
  radiobutton->setGeometry(10,15,140,25);
  if (int_graph.y_grid_space < 0) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Auto spacing", y_grid);
  radiobutton->setGeometry(10,40,140,25);
  if (int_graph.y_grid_space == 0) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Manual spacing", y_grid);
  radiobutton->setGeometry(10,65,140,25);
  if (int_graph.y_grid_space > 0) radiobutton->setChecked(TRUE);
  y_grid->setGeometry(30,310,160,95);
  connect(y_grid, SIGNAL(pressed(int)), SLOT(ygrid_pressed(int)) );
  
  edit_y_grid = new QLineEdit(draw_page);   // Set up line edit for y grid
  edit_y_grid->setGeometry( 220, 355, 150, 30 );
  if (int_graph.y_grid_space > 0) {
    text.setNum( int_graph.y_grid_space , 'G' );
    edit_y_grid->setText( text );
  }
  else {
    edit_y_grid->setEnabled(false);
  }
  label = new QLabel("Vertical grid spacing",draw_page);
  label->setGeometry( 220, 335, 150, 20 );


  setOKButton();
  setCancelButton();
  connect(this, SIGNAL(applyButtonPressed()), SLOT(apply()));
}

GraphBaseDlg::~GraphBaseDlg()
{
}

// Convert a text string to a value
double
GraphBaseDlg::EvalText(const char *ctext)
{
  error_struct err;
  double value;
  Equation *eqn;

  int length = strlen( ctext );
  char *text = new char[ length + 1 ];
  strncpy( text, ctext, length + 1 );
  Error = false;
  try {
    eqn = parser->TextToTree(text);
    if (eqn->Variables.count() > 0) {
      err.err_type = ERR_VARIABLES;
      err.extra = NULL;
      err.del = false;
      throw err;
    }
    eqn->Radians = true;
    value = eqn->Evaluate();
  }
  catch (...) {
    Error = true;
    return 0;
  }
  delete text;
  delete eqn;
  return value;
}

// Auto selected
void GraphBaseDlg::auto_pressed( int id )
{
  if ( id == 0  ) {
    int_graph.Auto = true;
    x_from->setEnabled(false);
    x_to->setEnabled(false);
    y_from->setEnabled(false);
    y_to->setEnabled(false);
  }
  else {
    int_graph.Auto = false;
    x_from->setEnabled(true);
    x_to->setEnabled(true);
    y_from->setEnabled(true);
    y_to->setEnabled(true);
  };
}

// x tic selected
void
GraphBaseDlg::xtic_pressed(int id)
{
  if (id == 0) {
    edit_x_tic->setEnabled(false);
  }
  else {
    edit_x_tic->setEnabled(true);
  }
}

// y tic selected
void
GraphBaseDlg::ytic_pressed(int id)
{
  if (id == 0) {
    edit_y_tic->setEnabled(false);
  }
  else {
    edit_y_tic->setEnabled(true);
  }
}

// x grid selected
void
GraphBaseDlg::xgrid_pressed(int id)
{
  if (id == 2) {
    edit_x_grid->setEnabled(true);
  }
  else {
    edit_x_grid->setEnabled(false);
  }
}

// y grid selected
void
GraphBaseDlg::ygrid_pressed(int id)
{
  if (id == 2) {
    edit_y_grid->setEnabled(true);
  }
  else {
    edit_y_grid->setEnabled(false);

  }
}

// Change graph values when OK pressed and return
void GraphBaseDlg::apply()
{
  QString text;

  int_graph.xmin = EvalText( x_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };
  
  int_graph.xmax = EvalText( x_to->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

  if ( int_graph.xmin >= int_graph.xmax ) {
    Error = true;
    QMessageBox::message("Error!","Range must be positive");
    return;
  };

  int_graph.ymin = EvalText( y_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };
  
  int_graph.ymax = EvalText( y_to->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

  if ( int_graph.ymin >= int_graph.ymax ) {
    Error = true;
    QMessageBox::message("Error!","From value must be greater than to value");
    return;
  };

  if ( x_tic->find(0)->isOn() ) {
    int_graph.x_tic_space = 0;
  }
  else {
    int_graph.x_tic_space = EvalText( edit_x_tic->text() );
    if (int_graph.x_tic_space <= 0)
      Error = true;
    if (Error) {
      QMessageBox::message("Error!","Not a valid horizontal tic spacing value");
      return;
    }
  }

  if ( y_tic->find(0)->isOn() ) {
    int_graph.y_tic_space = 0;
  }
  else {
    int_graph.y_tic_space = EvalText( edit_y_tic->text() );
    if (int_graph.y_tic_space <= 0)
      Error = true;
    if (Error) {
      QMessageBox::message("Error!","Not a valid vertical tic spacing value");
      return;
    }
  }

  if ( x_grid->find(0)->isOn() ) {
    int_graph.x_grid_space = -1;
  }
  else {
    if ( x_grid->find(1)->isOn() ) {
      int_graph.x_grid_space = 0;
    }
    else {
      int_graph.x_grid_space = EvalText( edit_x_grid->text() );
      if (int_graph.x_grid_space <= 0)
	Error = true;
      if (Error) {
	QMessageBox::message("Error!","Not a valid horizontal grid spacing value");
	return;
      }
    }
  }

  if ( y_grid->find(0)->isOn() ) {
    int_graph.y_grid_space = -1;
  }
  else {
    if ( y_grid->find(1)->isOn() ) {
      int_graph.y_grid_space = 0;
    }
    else {
      int_graph.y_grid_space = EvalText( edit_y_grid->text() );
      if (int_graph.y_grid_space <= 0)
	Error = true;
      if (Error) {
	QMessageBox::message("Error!","Not a valid vertical grid spacing value");
	return;
      }
    }
  }

  *graph = int_graph;
}

#include "grbase.moc"







