/*  -*- c++ -*-
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef GRAPHTAB_H_
#define GRAPHTAB_H_
/* Header file for GraphTabDlg dialog class */

#include "grbase.h"
#include <qlistbox.h>
#include <qchkbox.h>
#include <qcombo.h>

class GraphTabDlg : public GraphBaseDlg
{
  Q_OBJECT
 public:
  GraphTabDlg( graphsize *, QList<Equation> *, int *, int, int *, Parser *, QTextStream *,  char * =0 );
  ~GraphTabDlg();

 public slots:
  void apply();
  void select_var(int);
  void select_param(int);
  void type_pressed(int);
  void replot_pressed(int);
  void edit_pressed();

 protected:
  QTextStream *stream;
  QWidget *eqn_page, *param_page;

  // Widgets for equation tab
  QButtonGroup *GraphType;
  QLabel *equ1_label;
  QLabel *equ2_label;
  QLineEdit *equ1_value;
  QComboBox *equ2_combo;
  QListBox *var_listbox;
  QButtonGroup *Replot;

  // Widgets for parameter tab
  QLineEdit *value_edit;
  QListBox *param_listbox;

  int selected_var, selected_param, int_equ2;
  int numEqu;
  int *var_num, *num_equ2;
  QList<Equation> *eqns;
  Equation *equ;
  double *var_values;
};

#endif /* GRAPHTAB_H_ */







