/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for GraphTabDlg dialog class

#include "graphtab.h"
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlabel.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qregexp.h>
#include "../equations/errors.h"

GraphTabDlg::GraphTabDlg( graphsize *g, QList<Equation> *e, int *v, int e1, int *e2, Parser *p, QTextStream *s, char *name ) : GraphBaseDlg(g, p, name)
{
  QString text;
  QLabel *label;
  Equation *eqn;
  variable *var;
  int i;

  stream = s;

  num_equ2 = e2;
  int_equ2 = *e2 - 1;
  var_num = v;
  eqns = e;
  equ = eqns->at(e1-1);
  numEqu = eqns->count();

  i = equ->Variables.count();
  if (i)
    var_values = new double[i];
  else
    var_values = NULL;

  //  resize( 400 , 500 );

  // Create widgets for the 3 pages
  eqn_page = new QWidget(this, "eqn_tab");
  eqn_page->resize(300,350);
  param_page = new QWidget(this, "param_tab");
  param_page->resize(300,350);

  setCaption("Plot graph");


  // Widgets for the equation tab
  GraphType = new QButtonGroup(eqn_page);   // Set up graph type radio buttons
  GraphType->setTitle("Set graph type");
  GraphType->setGeometry(50,20,270,80);
  QRadioButton *radiobutton = new QRadioButton("Cartesian",GraphType);
  radiobutton->setGeometry(10,15,120,25);
  radiobutton = new QRadioButton("Polar",GraphType);
  radiobutton->setGeometry(10,45,120,25);
  radiobutton = new QRadioButton("Parametric",GraphType);
  radiobutton->setGeometry(140,15,120,25);
  radiobutton = new QRadioButton("Parametric polar",GraphType);
  radiobutton->setGeometry(140,45,120,25);
  connect(GraphType, SIGNAL(pressed(int)), SLOT(type_pressed(int)) );

  equ1_label = new QLabel(eqn_page);
  equ1_label->setGeometry( 30, 110, 150, 20 );
  equ1_value = new QLineEdit(eqn_page);
  equ1_value->setText(equ->EquationText);
  equ1_value->setEnabled(false);
  equ1_value->setGeometry( 30, 130, 350, 30 );

  equ2_label = new QLabel(eqn_page);
  equ2_label->setGeometry( 30, 170, 150, 20 );
  equ2_combo = new QComboBox(false, eqn_page);
  eqn = eqns->first();
  while ( eqn ) {
    equ2_combo->insertItem(eqn->EquationText);
    eqn = eqns->next();
  }
  equ2_combo->setGeometry( 30, 190, 350, 30 );
  if ((int_equ2 >= 0) && (int_equ2 < numEqu))  {
    equ2_combo->setCurrentItem( int_equ2 );
  }

  if ( int_graph.Cartesian ) {
    if ( int_graph.Parametric ) {
      equ1_label->setText("Horizontal 'x' value = ");
      equ2_label->setText("Vertical 'y' value = ");
      ((QRadioButton *)GraphType->find(2))->setChecked(TRUE);
    }
    else {
      ((QRadioButton *)GraphType->find(0))->setChecked(TRUE);
      equ1_label->setText("Vertical 'y' value = ");
      equ2_label->setText("N/A");
      equ2_combo->setEnabled(false);
    }
  }
  else {
    if ( int_graph.Parametric ) {
      ((QRadioButton *)GraphType->find(3))->setChecked(TRUE);
      equ1_label->setText("Radial 'r' value = ");
      equ2_label->setText("Angular 'theta' value = ");
    }
    else {
      ((QRadioButton *)GraphType->find(1))->setChecked(TRUE);
      equ1_label->setText("Radial 'r' value = ");
      equ2_label->setText("N/A");
      equ2_combo->setEnabled(false);
    }
  }

  // Text above x listbox
  label = new QLabel( "Variable to\nplot against", eqn_page );
  label->setGeometry(20,245,100,30);
  label->setAlignment( AlignCenter );
  // Set up listbox of variables
  var_listbox = new QListBox( eqn_page );
  var = equ->Variables.first();
  i = 0; // Use this to get variable values too
  var_listbox->insertItem("NONE");
  while ( var ) {
    var_listbox->insertItem(var->Name);
    var_values[i] = var->Value;
    i++;
    var = equ->Variables.next();
  }
  var = equ->Variables.first();
  var_listbox->setGeometry( 20, 280, 100, 100 );
  if (var != NULL) {
    var_listbox->setCurrentItem( 1 );
    selected_var = 1;
  }
  else {
    var_listbox->setCurrentItem( 0 );
    selected_var = 0;
  }
  connect( var_listbox, SIGNAL(selected(int)), SLOT(select_var(int)) );
  connect( var_listbox, SIGNAL(highlighted(int)), SLOT(select_var(int)) );

  Replot = new QButtonGroup(eqn_page);  // Set up plot / replot radio button
  Replot->setTitle("Graph");
  radiobutton = new QRadioButton("Plot new graph", Replot);
  radiobutton->setGeometry(10,15,140,25);
  if (!int_graph.Replot) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Add to last graph", Replot);
  radiobutton->setGeometry(10,45,140,25);
  if (int_graph.Replot) radiobutton->setChecked(TRUE);
  Replot->setGeometry(180,280,160,80);
  connect(Replot, SIGNAL(pressed(int)), SLOT(replot_pressed(int)) );
  

  // Widgets for the parameter tab
  label = new QLabel( "Set parameter values", param_page );
  label->setGeometry(30,10,290,15);
  label->setAlignment( AlignCenter );

  param_listbox = new QListBox(param_page);   // Set up listbox of variables
  var = equ->Variables.first();
  while ( var ) {
    param_listbox->insertItem(var->Name);
    var = equ->Variables.next();
  }
  var = equ->Variables.first();
  param_listbox->setGeometry( 30, 50, 100, 110 );
  if (var) {
    param_listbox->setCurrentItem( 0 );    
    selected_param = 0;
  }
  else {
    selected_var = -1;
  }
  connect( param_listbox, SIGNAL(selected(int)), SLOT(select_param(int)) );
  connect( param_listbox, SIGNAL(highlighted(int)), SLOT(select_param(int)) );

  label = new QLabel( "Paramter", param_page );
  label->setGeometry(30,30,100,15);
  label->setAlignment( AlignCenter );

  value_edit = new QLineEdit(param_page);   // Set up line edit for value
  value_edit->setGeometry( 180, 50, 150, 30 );
  if (var_values) {
    text.setNum( var_values[0] , 'G' );
    value_edit->setText( text );
  }
  else {
    value_edit->setText("");
  }
  value_edit->setEnabled(false);
  connect( value_edit, SIGNAL(returnPressed()), SLOT(edit_pressed()) );
  label = new QLabel( "Value", param_page );
  label->setGeometry(180,30,100,20);
  label->setAlignment( AlignCenter );

  addTab(eqn_page, "Equations");
  addTab(range_page, "Range");
  addTab(draw_page, "Draw");
  addTab(param_page, "Parameters");
}

GraphTabDlg::~GraphTabDlg()
{
  delete edit_from;
  delete edit_to;
  delete value_edit;
  delete var_listbox;
  delete param_listbox;
  if (var_values)
    delete var_values;
}

// Grey/ungrey dialogs when graph type changed selected
void GraphTabDlg::type_pressed( int id )
{
  switch (id) {
  case 0:
    int_graph.Cartesian = true;
    int_graph.Parametric = false;
    equ1_label->setText("Vertical 'y' value = ");
    equ2_label->setText("N/A");
    equ2_combo->setEnabled(false);
    break;
  case 1:
    int_graph.Cartesian = false;
    int_graph.Parametric = false;
    equ1_label->setText("Radial 'r' value = ");
    equ2_label->setText("N/A");
    equ2_combo->setEnabled(false);
    break;
  case 2:
    int_graph.Cartesian = true;
    int_graph.Parametric = true;
    equ1_label->setText("Horizontal 'x' value = ");
    equ2_label->setText("Vertical 'y' value = ");
    equ2_combo->setEnabled(true);
    break;
  case 3:
    int_graph.Cartesian = false;
    int_graph.Parametric = true;
    equ1_label->setText("Radial 'r' value = ");
    equ2_label->setText("Angular 'theta' value = ");
    equ2_combo->setEnabled(true);
    break;
  }
}

// Replot selected
void GraphTabDlg::replot_pressed( int id )
{
  if ( id == 1  ) {
    int_graph.Replot = true;
  }
  else {
    int_graph.Replot = false;
  };
}

// Change current variable when listbox selected and update value to edit
void GraphTabDlg::select_param(int selection)    
{
  QString text;
  variable *var;

  // Change value
  edit_pressed();

  selected_param = selection;
  var = equ->Variables.at(selection);
  if (var) {
    text.setNum( var_values[selection] , 'G' );
    value_edit->setText( text );
    value_edit->update();
  };
  if (selection == selected_var-1) {
    value_edit->setEnabled(false);
  }
  else {
    value_edit->setEnabled(true);
  }

}

// Set variable to plot against
void GraphTabDlg::select_var(int selection)
{
  selected_var = selection;

  if (selection == selected_param+1) {
    value_edit->setEnabled(false);
  }
  else {
    value_edit->setEnabled(true);
  }

}

// Get value from line edit and change value of parameter 
void GraphTabDlg::edit_pressed()
{
  double value;
  
  value = EvalText( value_edit->text() );
  if ( !Error ) {
    var_values[selected_param] = value;
    if (stream) {
      *stream << (equ->Variables.at(selected_param))->Name;
      *stream << " = ";
      *stream << value;
      *stream << "\n";
    }
  } 
  else {
    QMessageBox::message("Error!","Not a valid value");
  };
}

// Change graph values when OK pressed and return
void GraphTabDlg::apply()
{
  int i;
  variable *var;
  QString text;

  int_graph.varmin = EvalText( edit_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };
  
  int_graph.varmax = EvalText( edit_to->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

  if ( int_graph.varmin >= int_graph.varmax ) {
    QMessageBox::message("Error!","Range for variable must be positive");
    return;
  };

  GraphBaseDlg::apply();
  if (Error)
    return;

  *graph = int_graph;
  *var_num = selected_var;
  if ( int_graph.Parametric ) {
    *num_equ2 = equ2_combo->currentItem() + 1;
  }

  var = equ->Variables.first();
  i = 0;
  while (var) {
    var->Value = var_values[i];
    i++;
    var = equ->Variables.next();
  }    

}

#include "graphtab.moc"







