/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for EqnDialog dialog class

#include "eqndialog.h"
#include "../equations/parser.h"
#include "../equations/errors.h"

// EqnDialog constructor
EqnDialog::EqnDialog( Parser *p, QWidget *parent, const char *name, bool modal, WFlags w ) : QDialog( parent, name, modal, w )
{
  parser = p;
}

// EqnDialog destructor
EqnDialog::~EqnDialog()
{
}

// Convert a text string to a value
double
EqnDialog::EvalText(const char *ctext)
{
  error_struct err;
  double value;
  Equation *eqn;

  int length = strlen( ctext );
  char *text = new char[ length + 1 ];
  strncpy( text, ctext, length + 1 );
  Error = false;
  try {
    eqn = parser->TextToTree(text);
    if (eqn->Variables.count() > 0) {
      err.err_type = ERR_VARIABLES;
      err.extra = NULL;
      err.del = false;
      throw err;
    }
    eqn->Radians = true;
    value = eqn->Evaluate();
  }
  catch (...) {
    Error = true;
    return 0;
  }
  delete text;
  delete eqn;
  return value;
}

#include "eqndialog.moc"




