/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/


// File for Diff dialog class

#include "diff.h"
#include <qpushbt.h>
#include <qlabel.h>

Diff::Diff( int *v, Equation *equation, char *name ) : QDialog( 0, name, TRUE )
{
  var_num = v;
  variable *var;

  resize( 260 , 200 );

  QLabel *label = new QLabel( "Differentiate variable" , this );
  label->setGeometry(30,10,200,15);
  label->setAlignment( AlignCenter );

  label = new QLabel( "Variable", this );   // Text above listbox
  label->setGeometry(30,30,100,15);
  label->setAlignment( AlignCenter );

  listbox = new QListBox(this);   // Set up listbox of variables
  var = equation->Variables.first();
  while ( var ) {
    listbox->insertItem(var->Name);
    var = equation->Variables.next();
  }
  var = equation->Variables.first();
  listbox->setGeometry( 30, 50, 100, 130 );
  listbox->setCurrentItem( 0 );
  connect( listbox, SIGNAL(selected(int)), SLOT(listbox_selected(int)) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button
  button->setGeometry( 160, 50, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->setGeometry( 160, 120, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  listbox->setFocus();  
}


Diff::~Diff()
{
  delete listbox;
}

// Change variable when listbox selected and return 
void Diff::listbox_selected(int selection)    
{
  *var_num = selection+1;
  accept();
}

// Change variable when OK pressed and return
void Diff::button_ok()
{
  *var_num = listbox->currentItem()+1;
  accept();
}

#include "diff.moc"
