/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for SetVar dialog class

#include "setvar.h"
#include <qpushbt.h>
#include <qmsgbox.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qstring.h>

SetVar::SetVar(Equation *eqn, QTextStream *s, Parser *p, const char *name) : EqnDialog(p,0,name,TRUE)
{
  QString text;
  equation = eqn;
  stream = s;

  resize( 350 , 230 );

  QLabel *label = new QLabel( "Set variable values", this );
  label->setGeometry(30,10,290,15);
  label->setAlignment( AlignCenter );

  listbox = new QListBox(this);   // Set up listbox of variables
  var = equation->Variables.first();
  while ( var ) {
    listbox->insertItem(var->Name);
    var = equation->Variables.next();
  }
  var = equation->Variables.first();
  listbox->setGeometry( 30, 50, 100, 110 );
  listbox->setCurrentItem( 0 );
  connect( listbox, SIGNAL(selected(int)), SLOT(listbox_selected(int)) );
  connect( listbox, SIGNAL(highlighted(int)), SLOT(listbox_selected(int)) );
  label = new QLabel( "Variable", this );
  label->setGeometry(30,30,100,15);
  label->setAlignment( AlignCenter );

  value_edit = new QLineEdit(this);   // Set up line edit for value
  value_edit->setGeometry( 180, 50, 150, 30 );
  text.setNum( var->Value , 'G' );
  value_edit->setText( text );
  connect( value_edit, SIGNAL(returnPressed()), SLOT(edit_pressed()) );
  label = new QLabel( "Value", this );
  label->setGeometry(180,30,100,20);
  label->setAlignment( AlignCenter );

  QPushButton *button = new QPushButton("Change",this); // Set up Change button
  button->setGeometry( 50, 180, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_change()) );

  button = new QPushButton("Done",this);  // Set up Done button
  button->setGeometry( 230, 180, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(accept()) );

  listbox->setFocus();

}

SetVar::~SetVar()
{
  delete listbox;
  delete value_edit;
}

// Get value from line edit and change value of variable 
void SetVar::button_change()
{
  double value;
  
  value = EvalText( value_edit->text() );
  if ( !Error ) {
    var->Value = value;
    if (stream) {
      *stream << var->Name;
      *stream << " = ";
      *stream << value;
      *stream << "\n";
    }
  }
  else {
    QMessageBox::message("Error!","Not a valid value");
  };
}

void SetVar::edit_pressed()
{
  button_change();
  accept();
}

// Change current variable when listbox selected and update value to edit
void SetVar::listbox_selected(int selection)    
{
  QString text;
 
  var = equation->Variables.at(selection);
  if (var) {
    text.setNum( var->Value , 'G' );
    value_edit->setText( text );
    value_edit->update();
  };
}

#include "setvar.moc"
