/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for Input class

#include "input.h"
#include <qpushbt.h>
#include <qlabel.h>

Input::Input( const char * text, QString *ret_string, const char * name) : QDialog(0,name,TRUE)
{
  Ret_string = ret_string;
  
  resize(300,150);   //Set size of dialog

  QLabel *label = new QLabel(text, this);    // Set up text label
  label->setGeometry(30,30,240,30);
  label->setAlignment( AlignCenter );

  edit = new QLineEdit(this);    //Set up line edit widget
  edit->setMaxLength(200);
  edit->setGeometry(30,60,240,20);
  edit->setText( Ret_string->data() );
  connect(edit, SIGNAL(returnPressed()), SLOT(button_ok()) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button 
  button->move(60,100);
  button->resize(70,30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->move(170,100);
  button->resize(70,30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  edit->setFocus();
}

Input::~Input()
{
  delete edit;
}

void Input::button_ok()
{
  *Ret_string = edit->text();
  accept();
}

void Input::setValue( QString *val )
{
  edit->setText( val->data() );  
  edit->setFocus();
}

#include "input.moc"



