/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#ifndef GRAPH_H_
#define GRAPH_H_
/* Header file for GraphDlg dialog class */

#include "eqndialog.h"
#include <qlistbox.h>
#include <qlined.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include "../equations/equ.h"

struct graphsize {
  double xmin;
  double xmax;
  double ymin;
  double ymax;
  bool Cartesian;
  bool Parametric;  
  bool Replot;
};

class GraphDlg : public EqnDialog
{
  Q_OBJECT
 public:
  GraphDlg( graphsize *, Equation *, int *, int *, int, Parser *, char * =0 );
  ~GraphDlg();

 public slots:
  void button_ok();
  void set_var();
  void parapressed(int);
  void cartpressed(int);

 protected:
  void grey();
  void ungrey();

 protected:
  Parser *parser;
  QLineEdit *edit_from;
  QLineEdit *edit_to;
  QLineEdit *edit_equ2;
  QListBox *listbox;
  QButtonGroup *Cart;
  QButtonGroup *Para;
  QCheckBox *Replot;
  graphsize *graph;
  bool CartStyle,ParaStyle;
  int numEqu;
  int *var_num;
  Equation *equ;
  int *equ2;
};

#endif /* GRAPH_H_ */







