/*
 * mtk - Maths Toolkit for X11
 *
 * Copyright 1994-1997   andrewr@chiark.greenend.org.uk (Andrew Ross)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

// File for GraphDlg dialog class

#include "graph.h"
#include "setvar.h"
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlabel.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qregexp.h>

GraphDlg::GraphDlg( graphsize *g, Equation *e, int *v, int *e2, int nume, Parser *p, char *name ) : EqnDialog( p, 0, name, TRUE )
{
  QString text;
  variable *var;
  parser = p;

  graph = g;
  CartStyle = graph->Cartesian;
  ParaStyle = graph->Parametric;
  var_num = v;
  equ = e;
  equ2 = e2;
  numEqu = nume;

  resize( 350 , 400 );

  QLabel *label = new QLabel( "Plot graph", this );
  label->setGeometry(30,10,290,20);
  label->setAlignment( AlignCenter );

  label = new QLabel( "variable", this );   // Text above x listbox
  label->setGeometry(10,140,100,20);
  label->setAlignment( AlignCenter );
  listbox = new QListBox( this );   // Set up listbox of variables
  var = equ->Variables.first();
  while ( var ) {
    listbox->insertItem(var->Name);
    var = equ->Variables.next();
  }
  var = equ->Variables.first();
  listbox->setGeometry( 10, 170, 100, 100 );
  if (var != NULL) listbox->setCurrentItem( 0 );

  Cart = new QButtonGroup(this);   // Set up cartesian radio buttons
  Cart->setTitle("Set type");
  QRadioButton *radiobutton = new QRadioButton("Cartesian",Cart);
  radiobutton->setGeometry(10,15,120,25);
  if ( CartStyle ) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Polar",Cart);
  radiobutton->setGeometry(10,45,120,25);
  if ( !CartStyle ) radiobutton->setChecked(TRUE);
  Cart->setGeometry(20,50,140,80);
  connect(Cart, SIGNAL(pressed(int)), SLOT(cartpressed(int)) );

  Para = new QButtonGroup(this);   // Set up parametric radio buttons
  Para->setTitle("Set parametric");
  radiobutton = new QRadioButton("Non-Parametric",Para);
  radiobutton->setGeometry(20,15,120,25);
  if ( !ParaStyle ) radiobutton->setChecked(TRUE);
  radiobutton = new QRadioButton("Parametric",Para);
  radiobutton->setGeometry(20,45,120,25);
  if ( ParaStyle ) radiobutton->setChecked(TRUE);
  Para->setGeometry(160,50,160,80);
  connect(Para, SIGNAL(pressed(int)), SLOT(parapressed(int)) );

  Replot = new QCheckBox("Plot new graph",this);
  Replot->setGeometry(10,300,160,20);
  if (graph->Replot) {
    Replot->setChecked(FALSE);
  }
  else {
    Replot->setChecked(TRUE);
  };

  label = new QLabel("Range",this);    // Set up labels
  label->setGeometry( 190, 140, 150, 20 );

  edit_from = new QLineEdit(this);   // Set up line edit for from
  edit_from->setGeometry( 190, 180, 150, 30 );
  text.setNum( graph->xmin , 'G' );
  edit_from->setText( text );
  label = new QLabel("From",this);
  label->setGeometry( 190, 160, 150, 20 );
  connect(edit_from, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_to = new QLineEdit(this);   // Set up line edit for to
  edit_to->setGeometry( 190, 240, 150, 30 );
  text.setNum( graph->xmax , 'G' );
  edit_to->setText( text );
  label = new QLabel("To",this);
  label->setGeometry( 190, 220, 150, 20 );
  connect(edit_to, SIGNAL(returnPressed()), SLOT(button_ok()) );

  edit_equ2 = new QLineEdit(this);   // Set up line edit for 2nd eqn
  edit_equ2->setGeometry( 190, 300, 150, 30 );
  text.setNum( *equ2 );
  edit_equ2->setText( text );
  label = new QLabel("Second equation",this);
  label->setGeometry( 190, 280, 150, 20 );
  connect(edit_equ2, SIGNAL(returnPressed()), SLOT(button_ok()) );

  QPushButton *button = new QPushButton("OK",this);  // Set up OK button
  button->setGeometry( 60, 340, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(button_ok()) );

  button = new QPushButton("Cancel",this);  // Set up Cancel button
  button->setGeometry( 150, 340, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(reject()) );

  button = new QPushButton("Set\nVariables",this);  // Set up Set variables button
  button->setGeometry( 240, 340, 70, 30);
  connect( button, SIGNAL(clicked()), SLOT(set_var()) );

  if ( !ParaStyle ) grey();

  listbox->setFocus();
}

GraphDlg::~GraphDlg()
{
  delete edit_from;
  delete edit_to;
  delete edit_equ2;
  delete listbox;
}

// Grey edit box
void GraphDlg::grey()
{
  edit_equ2->setEnabled(FALSE);
  edit_equ2->repaint();
}

// Ungrey edit box
void GraphDlg::ungrey()
{
  edit_equ2->setEnabled(TRUE);
  edit_equ2->repaint();
}

// Grey/ungrey dialogs when parametric selected
void GraphDlg::parapressed( int id )
{
  if ( id == 1  ) {
    ungrey();
    ParaStyle = true;
  }
  else {
    grey();
    ParaStyle = false;
  };
}

// Cartesian selected
void GraphDlg::cartpressed( int id )
{
  if ( id == 0  ) {
    CartStyle = true;
  }
  else {
    CartStyle = false;
  };
}

// Set Variables button pressed
void GraphDlg::set_var()
{
  SetVar SetVarVal( equ, NULL, parser );
  SetVarVal.exec();
}

// Change graph values when OK pressed and return
void GraphDlg::button_ok()
{
  graphsize r;
  int e;
  bool error_check;
  QString text;

  r.xmin = EvalText( edit_from->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid from value");
    return;
  };
  
  r.xmax = EvalText( edit_to->text() );
  if ( Error ) {
    QMessageBox::message("Error!","Not a valid to value");
    return;
  };

  if ( ParaStyle  ) {
    text = edit_equ2->text();
    e = text.toInt( &error_check );
    if ( ( !error_check ) || ( e < 1 ) || ( e > numEqu ) ) {
      QMessageBox::message("Error!","Not a valid second equation");
      return;
    };
  };
  if ( r.xmin >= r.xmax ) {
    QMessageBox::message("Error!","From value must be greater than to value");
    return;
  };
    
  graph->xmin = r.xmin;
  graph->xmax = r.xmax;

  graph->Parametric = ParaStyle;
  graph->Cartesian = CartStyle;
  if ( Replot->isChecked() ) {
    graph->Replot = false;
  }
  else {
    graph->Replot = true;
  };
  if (equ->Variables.count() > 0) *var_num = listbox->currentItem() + 1;
  else *var_num = 0;
  if ( ParaStyle ) *equ2 = e; 

  accept();
}

#include "graph.moc"







