/* map.cc
 * 
 * Copyright 2005-2009 Martin Read
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "dunbash.hh"
#include "monsters.hh"
#include "objects.hh"
#include "rooms.hh"

#include <string.h>
uint32_t depth = 1;
uint32_t dungeon = 0;
Level *currlev = 0;

Level::Level(int h, int w) : height(h), width(w)
{
    build();
}

Level::~Level()
{
    release();
}

void Level::release(void)
{
    int i;
    for (i = 0; i < 100; i++)
    {
	/* Throw away each monster */
        release_monster(i);
	/* and each object not carried by the player */
	if (!objects[i].with_you)
	{
	    objects[i].used = 0;
	}
    }
    for (i = 0; i < height; ++i)
    {
        free(mobjs[i]);
        free(mmons[i]);
        free(terrain[i]);
        free(rnums[i]);
        free(astar_invoc_num[i]);
        free(astar_considered[i]);
        free(came_from[i]);
        free(gscores[i]);
        free(mflags[i]);
    }
    free(mobjs);
    free(mmons);
    free(terrain);
    free(rnums);
    free(astar_invoc_num);
    free(astar_considered);
    free(came_from);
    free(gscores);
    free(mflags);
    delete levextra;
    levextra = 0;
}

void Level::leave(void)
{
    release();
    ++depth;
    status_updated = 1;
    map_updated = 1;
}

void make_new_level(void)
{
    if (!currlev)
    {
        currlev = new Level(DUN_HEIGHT, DUN_WIDTH);
    }
    else
    {
        currlev->height = DUN_HEIGHT;
        currlev->width = DUN_WIDTH;
        currlev->build();
    }
    currlev->excavate();
    currlev->populate();
    inject_player();
    touch_back_buffer();
    display_update();
}

void Level::excavate(void)
{
    levextra->excavate();
}

void Level::build(void)
{
    int i;
    int j;

    levtype = LEVEL_ROOMS;
    mobjs = (Obj_handle **) calloc(height, sizeof (Obj_handle *));
    mmons = (Mon_handle **) calloc(height, sizeof (Mon_handle *));
    rnums = (int **) calloc(height, sizeof (int *));
    terrain = (Terrain_num **) calloc(height, sizeof (Terrain_num *));
    astar_invoc_num = (uint32_t **) calloc(height, sizeof (uint32_t *));
    astar_considered = (uint32_t **) calloc(height, sizeof (uint32_t *));
    gscores = (uint32_t **) calloc(height, sizeof (uint32_t *));
    mflags = (uint32_t **) calloc(height, sizeof (uint32_t *));
    came_from = (libmrl::Coord **) calloc(height, sizeof (libmrl::Coord *));
    for (i = 0; i < height; ++i)
    {
        mobjs[i] = (Obj_handle *) malloc(width * sizeof (Obj_handle ));
        mmons[i] = (Mon_handle *) malloc(width * sizeof (Mon_handle ));
        rnums[i] = (int *) calloc(width, sizeof (int ));
        terrain[i] = (Terrain_num *) calloc(width, sizeof (Terrain_num ));
        astar_invoc_num[i] = (uint32_t *) calloc(width, sizeof (uint32_t ));
        astar_considered[i] = (uint32_t *) calloc(width, sizeof (uint32_t ));
        gscores[i] = (uint32_t *) calloc(width, sizeof (uint32_t ));
        mflags[i] = (uint32_t *) calloc(width, sizeof (uint32_t ));
        came_from[i] = (libmrl::Coord *) calloc(width, sizeof (libmrl::Coord ));
        for (j = 0; j < width; ++j)
        {
            mobjs[i][j] = NO_OBJECT;
            mmons[i][j] = NO_MONSTER;
            rnums[i][j] = NO_REGION;
            terrain[i][j] = WALL;
        }
    }
    levextra = new Levext_rooms();
    levextra->parent = this;
}

void Level::populate(void)
{
    levextra->populate();
}

void inject_player(void)
{
    libmrl::Coord c;
    c = currlev->levextra->get_injection_point();
    u.pos = c;
    reloc_player(u.pos);
}

/* map.cc */
