/* loadsave.hh
 * 
 * Copyright 2009 Martin Read
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LOADSAVE_HH
#define LOADSAVE_HH

#include <stdio.h>
#include <stdint.h>

inline void serialise(FILE *fp, uint16_t data)
{
    fputc(data >> 8, fp);
    fputc(data >> 0, fp);
}

inline void serialise(FILE *fp, uint32_t data)
{
    fputc(data >> 24, fp);
    fputc(data >> 16, fp);
    fputc(data >> 8, fp);
    fputc(data >> 0, fp);
}

inline void serialise(FILE *fp, uint32_t *buf, int len)
{
    int i;
    for (i = 0; i < len; ++i)
    {
        serialise(fp, buf[i]);
    }
}

inline void serialise_ohandle(FILE *fp, Obj_handle foo)
{
    serialise(fp, uint32_t(foo.value));
}

extern void serialise(FILE *fp, Level const *lp);
extern void serialise(FILE *fp, libmrl::Coord c);
extern void serialise(FILE *fp, Obj const *optr);
extern void serialise(FILE *fp, Mon const *mptr);
extern void serialise_ohandle_array(FILE *fp, Obj_handle const *array, int count);
extern void serialise_monsters(FILE *fp);
extern void serialise_objects(FILE *fp);
extern void serialise_permobj_vars(FILE *fp);

inline uint16_t deserialise_uint16(FILE *fp)
{
    uint16_t tmp;
    tmp = (fgetc(fp) & 0xff) << 8;
    tmp |= fgetc(fp) & 0xff;
    return tmp;
}

inline uint32_t deserialise_uint32(FILE *fp)
{
    uint32_t tmp;
    tmp = (fgetc(fp) & 0xff) << 24;
    tmp |= (fgetc(fp) & 0xff) << 16;
    tmp |= (fgetc(fp) & 0xff) << 8;
    tmp |= (fgetc(fp) & 0xff);
    return tmp;
}

inline void deserialise(FILE *fp, uint32_t *buf, int len)
{
    int i;
    for (i = 0; i < len; ++i)
    {
        buf[i] = deserialise_uint32(fp);
    }
}

extern void deserialise(FILE *fp, Obj *optr);
extern void deserialise(FILE *fp, Mon *mptr);
extern void deserialise(FILE *fp, libmrl::Coord *ppos);
extern void deserialise_ohandle_array(FILE *fp, Obj_handle *array, int count);
extern Level *deserialise_level(FILE *fp);
extern void deserialise_monsters(FILE *fp);
extern void deserialise_objects(FILE *fp);
extern void deserialise_permobj_vars(FILE *fp);

extern void save_game(void);
extern int load_game(void);

#endif

/* dunbash.hh */
