/* pmon2.c
 * 
 * Copyright 2005 Martin Read
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define PMON2_C
#include "dunbash.h"
#include "monsters.h"

int pmon_resists_fire(int pm)
{
	switch (pm)
	{
	case PM_WIZARD:
	case PM_DRAGON:
	case PM_LICH:
	case PM_DEMON:
		return 1;
	default:
		return 0;
	}
}

int pmon_resists_cold(int pm)
{
	switch (pm)
	{
	case PM_ICE_MONSTER:
	case PM_WIZARD:
	case PM_ZOMBIE:
	case PM_LICH:
	case PM_DEMON:
	case PM_VAMPIRE:
		return 1;
	default:
		return 0;
	}
}

int pmon_is_undead(int pm)
{
	switch (pm)
	{
	case PM_LICH:
	case PM_ZOMBIE:
	case PM_VAMPIRE:
		return 1;
	default:
		return 0;
	}
}

int pmon_is_stupid(int pm)
{
	switch (pm)
	{
	case PM_TROLL:
	case PM_NEWT:
	case PM_SNAKE:
	case PM_GIANT:
	case PM_WRAITH:
	case PM_RAT:
		return 1;
	default:
		return 0;
	}
	return 0;
}

int pmon_is_smart(int pm)
{
	switch (pm)
	{
	case PM_DUELLIST:
	case PM_WARLORD:
	case PM_WIZARD:
	case PM_ARCHMAGE:
	case PM_WRAITH:
	case PM_LICH:
	case PM_VAMPIRE:
	case PM_DEMON:
	case PM_DEFILER:
	case PM_BAD_ELF:
		return 1;
	default:
		return 0;
	}
}

int pmon_is_magician(int pm)
{
	switch (pm)
	{
	case PM_LICH:
	case PM_WIZARD:
	case PM_MASTER_LICH:
	case PM_ARCHMAGE:
	case PM_DEFILER:
		return 1;
	default:
		return 0;
	}
}

int pmon_is_archer(int pm)
{
	if (permons[pm].rdam > 0)
	{
		return 1;
	}
	return 0;
}


/* pmon2.c */
