/* permons.c
 * 
 * Copyright 2005 Martin Read
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define PERMONS_C
#include "dunbash.h"

struct permon permons[100] = {
	[PM_NEWT] =
	{
		"newt", "newts", 'n', 20, 1, 3, 0, 2, 1, 1, 0
	},
	[PM_GOBLIN] =
	{
		/* may drop a dagger */
		"goblin", "goblins", 'g', 20, 1, 6, 1, 3, 3, 3, 1
	},
	[PM_RAT] =
	{
		"rat", "rats", 'r', 15, 1, 4, 0, 2, 4, 2, 2
	},
	[PM_THUG] =
	{
		/* may drop a mace or leather armour */
		"thug", "thugs", 't', 30, 1, 8, 5, 5, 6, 5, 1
	},
	[PM_BAD_ELF] =
	{
		"bad elf", "bad elves", 'e', 40, 3, 15, 10, 6, 12, 15, 2
	},
	[PM_GOON] =
	{
		"goon", "goons", 'G', 20, 3, 20, 6, 10, 8, 10, 1
	},
	[PM_ZOMBIE] =
	{
		"zombie", "zombies", 'z', 25, 3, 30, 2, 20, 5, 7, 0
	},
	[PM_WOLF] =
	{
		"wolf", "wolves", 'w', 30, 6, 20, 8, 10, 10, 15, 2
	},
	[PM_ICE_MONSTER] =
	{
		/* Fires ice blasts (ring of frost resists) */
		"ice monster", "ice monsters", 'I', 50, 6, 40, 10, 15, 20, 35, 0
	},
	[PM_SNAKE] =
	{
		/* Saps one Body on a perfect hit */
		"snake", "snakes", 's', 20, 6, 15, 10, 3, 10, 40, 2
	},
	[PM_HUNTER] =
	{
		/* Has a ranged attack - arrows */
		"hunter", "hunters", 'h', 30, 9, 40, 20, 10, 15, 50, 1
	},
	[PM_CENTAUR] =
	{
		"centaur", "centaurs", 'c', 30, 9, 40, 15, 10, 15, 50, 2 
	},
	[PM_TROLL] =
	{
		"troll", "trolls", 'T', 20, 12, 80, 15, 15, 15, 150, 1
	},
	[PM_DUELLIST] =
	{
		"duellist", "duellists", 'd', 40, 12, 60, 30, 15, 20, 130, 1
	},
	[PM_WIZARD] =
	{
		/* Casts lightning bolts (unresistable). */
		"wizard", "wizards", 'w', 80, 12, 40, 20, 10, 15, 200, 1
	},
	[PM_DRAGON] =
	{
		/* Breathes fire (ring of fire resists). */
		"dragon", "dragons", 'D', 50, 15, 80, 20, 20, 20, 300, 1
	},
	[PM_LICH] =
	{
		/* Casts bolts of death magic (vampire ring resists). */
		"lich", "liches", 'L', 70, 15, 70, 25, 15, 15, 250, 1
	},
	[PM_WARLORD] =
	{
		"warlord", "warlords", 'W', 30, 15, 80, 25, 20, 20, 400, 2
	},
	[PM_DEMON] =
	{
		/* Demons summon more demons if you don't kill them
		 * quickly. */
		"demon", "demons", '&', 60, 18, 40, 25, 20, 20, 500, 1
	},
	[PM_VAMPIRE] =
	{
		/* Vampires heal by hitting you. */
		"vampire", "vampires", 'V', 55, 18, 70, 25, 15, 22, 750, 1
	},
};

/* permons.c */
