/* permobj.c
 * 
 * Copyright 2005 Martin Read
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define PERMOBJ_C
#include "dunbash.h"

struct permobj permobjs[100] = {
	[PO_DAGGER] =
	{
		"dagger", "daggers", POCLASS_WEAPON, 25, ')', 4, 1, 1
	},
	[PO_LONG_SWORD] =
	{
		"long sword", "long swords", POCLASS_WEAPON, 30, ')', 10, 1, 1
	},
	[PO_MACE] =
	{
		"mace", "maces", POCLASS_WEAPON, 30, ')', 7, 1, 1
	},
	[PO_RUNESWORD] =
	{
		"runesword", "runeswords", POCLASS_WEAPON, 80, ')', 20, 1, 1
	},
	[PO_BOW] =
	{
		"bow", "bows", POCLASS_WEAPON, 45, '(', 8, 1, 1
	},
	[PO_CROSSBOW] =
	{
		"crossbow", "crossbows", POCLASS_WEAPON, 70, '(', 16, 1, 1
	},
	[PO_POT_HEAL] =
	{
		"healing potion", "healing potions", POCLASS_POTION, 10, '!', 0, 1, 0
	},
	[PO_POT_POISON] =
	{
		"poison potion", "poison potions", POCLASS_POTION, 10, '!', 0, 1, 0
	},
	[PO_POT_BODY] =
	{
		"body potion", "body potions", POCLASS_POTION, 50, '!', 0, 1, 0
	},
	[PO_POT_AGILITY] =
	{
		"agility potion", "agility potions", POCLASS_POTION, 50, '!', 0, 1, 0
	},
	[PO_POT_WEAKNESS] =
	{
		"weakness potion", "weakness potions", POCLASS_POTION, 40, '!', 0, 1, 0
	},
	[PO_SCR_TELEPORT] =
	{
		"teleport scroll", "teleport scrolls", POCLASS_SCROLL, 40, '?', 0, 1, 0
	},
	[PO_SCR_FIRE] =
	{
		"fire scroll", "fire scrolls", POCLASS_SCROLL, 30, '?', 0, 1, 0
	},
	[PO_SCR_MONSTERS] =
	{
		"summoning scroll", "summoning scrolls", POCLASS_SCROLL, 30, '?', 0, 1, 0
	},
	[PO_SCR_IDENTIFY] =
	{
		"identify scroll", "identify scrolls", POCLASS_SCROLL, 70, '?', 0, 1, 0
	},
	[PO_LEATHER_ARMOUR] =
	{
		"leather armour", "suits of leather armour", POCLASS_ARMOUR, 15, '[', 3, 1, 1
	},
	[PO_CHAINMAIL] =
	{
		"chainmail", "suits of chainmail", POCLASS_ARMOUR, 20, '[', 6, 1, 1
	},
	[PO_PLATE_ARMOUR] =
	{
		"plate armour", "suits of plate armour", POCLASS_ARMOUR, 40, '[', 10, 1, 1
	},
	[PO_MAGE_ARMOUR] =
	{
		"mage armour", "suits of mage armour", POCLASS_ARMOUR, 70, '[', 15, 1, 1
	},
	[PO_ROBE] =
	{
		"robe", "robes", POCLASS_ARMOUR, 50, '[', 2, 1, 1
	},
	[PO_ROBE_SWIFTNESS] =
	{
		"robe of swiftness", "robes of swiftness", POCLASS_ARMOUR, 70, '[', 8, 1, 0
	},
	[PO_ROBE_SHADOWS] =
	{
		"robe of shadows", "robes of shadows", POCLASS_ARMOUR, 90, '[', 20, 1, 0
	},
	[PO_RING_REGEN] =
	{
		"regeneration ring", "regeneration rings", POCLASS_RING, 70, '=', 0, 1, 0
	},
	[PO_RING_FIRE] =
	{
		"fire ring", "fire rings", POCLASS_RING, 50, '=', 0, 1, 0
	},
	[PO_RING_WEDDING] =
	{
		"wedding ring", "wedding rings", POCLASS_RING, 20, '=', 0, 1, 0
	},
	[PO_RING_VAMPIRE] =
	{
		"vampire ring", "vampire rings", POCLASS_RING, 90, '=', 0, 1, 0
	},
	[PO_RING_FROST] =
	{
		"frost ring", "frost rings", POCLASS_RING, 40, '=', 0, 1, 0
	},
	[PO_RING_DOOM] =
	{
		"doom ring", "doom rings", POCLASS_RING, 80, '=', 0, 1, 0
	},
	[PO_RING_TELEPORT] =
	{
		"teleport ring", "teleport rings", POCLASS_RING, 70, '=', 0, 1, 0
	},
	[PO_GOLD] =
	{
		"gold piece", "gold pieces", POCLASS_NONE, 1, '$', 0, 1, 1
	},
};

/* permobj.c */
